<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->hasOne('App\Models\LocationType');
    }

    public function parts()
    {
        return $this->hasMany('App\Models\Location');
    }

    public function parent()
    {
        return $this->hasOne('App\Models\Location');
    }

    public function center()
    {
        return $this->hasOne('App\Models\Center');
    }

    public function activities()
    {
        return $this->hasManyThrough('App\Models\Activity', 'App\Models\LocationActivity');
    }

    public function block()
    {
        return $this->hasOne('App\Models\Block');
    }

}